### DoNotCompareWithNaNRule
As defined in IEEE 754 it's impossible to compare any floating-point value, even another **NaN**, with **NaN**. Such comparison will always return **false**(more information on [wikipedia](http://en.wikipedia.org/wiki/NaN)). The framework provides methods, **Single.IsNaN** and **Double.IsNaN**, to check for **NaN** values.

**Bad** example:

``` csharp
double d = ComplexCalculation ();
if (d == Double.NaN) {
    // this will never be reached, even if d is NaN
    Console.WriteLine ("No solution exists!");
}
```
**Good** example:

``` csharp
double d = ComplexCalculation ();
if (Double.IsNaN (d)) {
    Console.WriteLine ("No solution exists!");
}
```