### DoNotExposeNestedGenericSignaturesRule
This rule will fire if an externally visible method has a parameter or return type whose type is a generic type which contains a generic type. For example, **List\<List\<int\>\>**. Such types are hard to construct and should be avoided because simpler alternatives generally exist. Since some language, like C#, have direct support for nullable types, i.e. **Nullable\<T\>** this specific case is ignored by the rule.

**Bad** example:

``` csharp
public class Generic<T> {
    public void Process (KeyValuePair<T, ICollection<int>> value)
    {
    }
}
```
**Good** example:

``` csharp
public class Generic<T> {
    public void Process (KeyValuePair<T, int[]> value)
    {
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.4
