### DoNotRecurseInEqualityRule
An operator== or operator!= method is calling itself recursively. This is usually caused by neglecting to cast an argument to System.Object before comparing it to null.

**Bad** example:

``` csharp
public static bool operator== (Customer lhs, Customer rhs)
{
    if (object.ReferenceEquals (lhs, rhs)) {
        return true;
    }
    if (lhs == null || rhs == null) {
        return false;
    }
    return lhs.name == rhs.name && lhs.address == rhs.address;
}
```
**Good** example:

``` csharp
public static bool operator== (Customer lhs, Customer rhs)
{
    if (object.ReferenceEquals (lhs, rhs)) {
        return true;
    }
    if ((object) lhs == null || (object) rhs == null) {
        return false;
    }
    return lhs.name == rhs.name && lhs.address == rhs.address;
}
```
**Notes**

-   This rule is available since Gendarme 2.4
