### DoNotUseReservedInEnumValueNamesRule
This rule checks for enumerations that contain values named **reserved**. This practice, often seen in C/C++ sources, is not needed in .NET since adding new values will not normally break binary compatibility. However renaming a **reserved**enum value can since there is no way to prevent people from using the old value.

**Bad** example:

``` csharp
public enum Answer {
    Yes,
    No,
    Reserved
    // ^ renaming this to 'Maybe' would be a breaking change
}
```
**Good** example:

``` csharp
public enum Answer {
    Yes,
    No
    // we can add Maybe here without causing a breaking change
    // (but note that we may break code if we change the values of
    // existing enumerations)
}
```