### EqualsShouldHandleNullArgRule
This rule ensures that **Equals(object)** methods return **false** when the object parameter is **null**.

**Bad** example:

``` csharp
public bool Equals (object obj)
{
    // this would throw a NullReferenceException instead of returning false
    return ToString ().Equals (obj.ToString ());
}
```
**Good** example:

``` csharp
public override bool Equals (object obj)
{
    if (obj == null) {
        return false;
    }
    return ToString ().Equals (obj.ToString ());
}
```