### GetEntryAssemblyMayReturnNullRule
This rule warns when an assembly without an entry point (i.e. a dll or library) calls **Assembly.GetEntryAssembly ()**. This call is problematic since it will always return **null** when called from outside the root (main) application domain. This may become a problem inside libraries that can be used, for example, inside ASP.NET applications.

**Bad** example:

``` csharp
// this will throw a NullReferenceException from an ASP.NET page
Response.WriteLine (Assembly.GetEntryAssembly ().CodeBase);
```
**Good** example:

``` csharp
public class MainClass {
    static void Main ()
    {
        Console.WriteLine (Assembly.GetEntryAssembly ().CodeBase);
    }
}
```