### MarkAllNonSerializableFieldsRule
This rule checks for serializable types, i.e. decorated with the **[Serializable]**attribute, and checks to see if all its fields are serializable as well. If not the rule will fire unless the field is decorated with the **[NonSerialized]** attribute. The rule will also warn if the field type is an interface as it is not possible, before execution time, to know for certain if the type can be serialized or not.

**Bad** example:

``` csharp
class NonSerializableClass {
}
 
[Serializable]
class SerializableClass {
    NonSerializableClass field;
}
```
**Good** example:

``` csharp
class NonSerializableClass {
}
 
[Serializable]
class SerializableClass {
    [NonSerialized]
    NonSerializableClass field;
}
```
**Notes**

-   This rule is available since Gendarme 2.0
