### PreferStringIsNullOrEmptyRule
This rule checks methods for cases where **String.IsNullOrEmpty** could be used instead of doing separate null and length checks. This does not affect execution nor performance (much) but it does improve source code readability. This rule only applies to assemblies compiled with .NET 2.0 (or later).

**Bad** example:

``` csharp
public bool SendMessage (string message)
{
    if ((message == null) || (message.Length == 0)) {
        return false;
    }
    return SendMessage (Encode (message));
}
```
**Good** example:

``` csharp
public bool SendMessage (string message)
{
    if (String.IsNullOrEmpty (message)) {
        return false;
    }
    return SendMessage (Encode (message));
}
```
**Notes**

-   This rule is available since Gendarme 2.0

Feedback
========
Please report any documentation errors, typos or suggestions to the [Gendarme Google Group](http://groups.google.com/group/gendarme). Thanks!
