### ProtectCallToEventDelegatesRule
This rule checks that event invocations are safely implemented. In particular, the event must be copied into a local to avoid race conditions and it must be checked for null before it is used (events will normally be null until a delegate is added to them).

**Bad** example (no check):

``` csharp
public event EventHandler Loading;
 
protected void OnLoading (EventArgs e)
{
    // Loading field could be null, throwing a NullReferenceException
    Loading (this, e);
}
```
**Bad** example (race condition):

``` csharp
public event EventHandler Loading;
 
protected void OnLoading (EventArgs e)
{
    // Loading could be non-null here
    if (Loading != null) {
        // but be null once we get here :(
        Loading (this, e);
    }
}
```
**Good** example:

``` csharp
public event EventHandler Loading;
protected void OnLoading (EventArgs e)
{
    EventHandler handler = Loading;
    // handler is either null or non-null
    if (handler != null) {
        // and won't change (i.e. safe from a NullReferenceException)
        handler (this, e);
        // however it is still possible, like the original code, that
        // the Loading method will be removed before, or during its
        // execution. Your code should be safe against such occurance.
    }
}
```