### ProvideAlternativeNamesForOperatorOverloadsRule
The rule ensure that all overloaded operators are also accessible using named alternatives because some languages, like VB.NET, cannot use overloaded operators. For those languages named methods should be implemented that provide the same functionality. This rule verifies that a named alternative exists for each overloaded operator.

-   **op_UnaryPlus** : Plus
-   **op_UnaryNegation** : Negate
-   **op_LogicalNot** : LogicalNot
-   **op_OnesComplement** : OnesComplement

-   **op_Increment** : Increment
-   **op_Decrement** : Decrement
-   **op_True** : IsTrue
-   **op_False** : IsFalse

-   **op_Addition** : Add
-   **op_Subtraction** : Subtract
-   **op_Multiply** : Multiply
-   **op_Division** : Divide
-   **op_Modulus** : Modulus

-   **op_BitwiseAnd** : BitwiseAnd
-   **op_BitwiseOr** : BitwiseOr
-   **op_ExclusiveOr** : ExclusiveOr

-   **op_LeftShift** : LeftShift
-   **op_RightShift** : RightShift

-   **op_Equality** : Equals
-   **op_Inequality** : (not) Equals
-   **op_GreaterThan** : Compare
-   **op_LessThan** : Compare
-   **op_GreaterThanOrEqual** : Compare
-   **op_LessThanOrEqual** : Compare

**Bad** example:

``` csharp
class DoesNotImplementAlternative {
    public static int operator + (DoesNotOverloadOperatorEquals a, DoesNotOverloadOperatorEquals b)
    {
        return 0;
    }
}
```
**Good** example:

``` csharp
class DoesImplementAdd {
    public static int operator + (DoesImplementAdd a, DoesImplementAdd b)
    {
        return 0;
    }
 
    public int Add (DoesImplementAdd a)
    {
        return this + a;
    }
}
```