### RemoveUnusedLocalVariablesRule
This rule looks for unused local variables inside methods. This can leads to larger code (IL) size and longer JIT time, but note that some optimizing compilers can remove the locals so they won't be reported even if you can still see them in the source code. This could also be a typo in the source were a value is assigned to the wrong variable.

**Bad** example:

``` csharp
bool DualCheck ()
{
    bool b1 = true;
    bool b2 = CheckDetails ();
    if (b2) {
        // typo: a find-replace changed b1 into b2
        b2 = CheckMoreDetails ();
    }
    return b2 && b2;
}
```
**Good** example:

``` csharp
bool DualCheck ()
{
    bool b1 = true;
    bool b2 = CheckDetails ();
    if (b2) {
        b1 = CheckMoreDetails ();
    }
    return b1 && b2;
}
```
**Notes**

-   This rule is available since Gendarme 2.0
