### ReviewSealedTypeWithInheritanceDemandRule
This rule checks for sealed types that have **InheritanceDemand** declarative security applied to them. Since those types cannot be inherited from the **InheritanceDemand** will never be executed by the runtime. Check if the permission is required and, if so, change the **SecurityAction** to the correct one. Otherwise remove the permission.

**Bad** example:

``` csharp
[SecurityPermission (SecurityAction.InheritanceDemand, Unrestricted = true)]
public sealed class Bad {
}
```
**Good** example (non sealed):

``` csharp
[SecurityPermission (SecurityAction.InheritanceDemand, Unrestricted = true)]
public class Good {
}
```
**Good** example (LinkDemand):

``` csharp
[SecurityPermission (SecurityAction.LinkDemand, Unrestricted = true)]
public sealed class Good {
}
```
**Notes**

-   Before Gendarme 2.2 this rule was part of Gendarme.Rules.Security and named SealedTypeWithInheritanceDemandRule.
