### ToStringShouldNotReturnNullRule
This rule checks for overridden **ToString()** methods which return **null**. An appropriately descriptive string, or **string.Empty**, should be returned instead in order to make the value more useful (especially in debugging).

**Bad** example:

``` csharp
public override string ToString ()
{
    return (count == 0) ? null : count.ToString ();
}
```
**Good** example:

``` csharp
public override string ToString ()
{
    return count.ToString ();
}
```
**Notes**

-   Before Gendarme 2.4 this rule was named ToStringReturnsNull.

Feedback
========
Please report any documentation errors, typos or suggestions to the [Gendarme Google Group](http://groups.google.com/group/gendarme). Thanks!
