### TypesShouldBeInsideNamespacesRule
This rule will fire if a type which is visible outside the assembly is not declared within a namespace. Using namespaces greatly reduces the probability of name collisions, allows tools such as auto-complete to operate better, and can make the assemblies API clearer.

**Bad** example:

``` csharp
using System;
 
public class Configuration {
}
```
**Good** example:

``` csharp
using System;
 
namespace My.Stuff {
    public class Configuration {
    }
}
```