### UseGenericEventHandlerRule
This rule fires if an assembly targets .NET 2.0 or later and defines a delegate which can be replaced by **System.EventHandler\<TEventArgs\>**.

**Bad** example:

``` csharp
public delegate void AuthenticityHandler (object sender, AuthenticityEventArgs e);
 
public event AuthenticityHandler CheckingAuthenticity;
public event AuthenticityHandler CheckedAuthenticity;
```
**Good** example:

``` csharp
public event EventHandler<AuthenticityEventArgs> CheckingAuthenticity;
public event EventHandler<AuthenticityEventArgs> CheckedAuthenticity;
```
**Notes**

-   This rule is available since Gendarme 2.2

Feedback
========
Please report any documentation errors, typos or suggestions to the [Gendarme Google Group](http://groups.google.com/group/gendarme). Thanks!
