### UseValueInPropertySetterRule
This rule ensures all setter properties uses the value argument passed to the property.

**Bad** example:

``` csharp
public bool Active {
    get {
        return active;
    }
    // this can take a long time to figure out if the default value for active
    // is false (since most people will use the property to set it to true)
    set {
        active = true;
    }
}
```
**Good** example:

``` csharp
public bool Active {
    get {
        return active;
    }
    set {
        active = value;
    }
}
```
Feedback
========
Please report any documentation errors, typos or suggestions to the [Gendarme Google Group](http://groups.google.com/group/gendarme). Thanks!
