# echo won't expand escape sequences. Consider printf.

### Problematic code:

```sh
echo "Name:\t$value"
```

### Correct code:

```sh
printf "Name:\t%s\n" "$value"
```

### Rationale:

Backslash escapes like `\t` and `\n` are not expanded by echo, and become literal backslash-t, backslash-n.

`printf` does expand these sequences, and should be used instead.

Other, non-portable methods include `echo -e '\t'` and `echo $'\t'`. ShellCheck will warn if this is used in a script with shebang `#!/bin/sh`.

If you actually wanted a literal backslash-t, use

```sh
echo "\\t"
```

### Exceptions

None
