Naming the first argument 'self' is a very common Python convention.
Python docs offers a motivation for this convention:

    Often, the first argument of a method is called self.
    This is nothing more than a convention: the name self has absolutely no special meaning to Python.
    Note, however, that by not following the convention your code may be less readable to other Python programmers,
    and it is also conceivable that a class browser program might be written that relies upon such a convention.

"PEP 8: Function and Method Arguments" states the convention more crisply as a rule:

    Always use self for the first argument to instance methods.
      