The __iter__ methods must return an iterator in order to work properly.
An iterator is an object which implements the iterator protocol, which means that
it should implement two special methods, __iter__ and __next__.

For example, these implementations of __iter__ are not valid, since they don't return iterators,
but sequences or other collections.


    class Bad(object):
        def __iter__(self):
            return [1, 2, 3]

    class AnotherBadIterator(object):
        def __iter__(self):
            return range(10)


[SOURCE](https://docs.python.org/3/library/stdtypes.html?highlight=__iter__#iterator-types)