In Python 3, the from clause of the raise statement is used for exception chaining: if given, the second expression
must be another exception class or instance, which will then be attached to the raised exception as the __cause__
attribute (which is writable). If the raised exception is not handled, both exceptions will be printed.

For example, you might use it like this:

    try:
        ...
    except AttributeError as exc:
        raise OurOwnException from exc

[SOURCE](https://docs.python.org/3/reference/simple_stmts.html#raise)