The raise statement can be used without an exception, which will re-raise the last exception that
was active in the current scope. This is useful when it's used inside an except clause, but very
any other places, it can be misleading and hard to understand why it is placed there.

Here are some examples where the raise statement shouldn't be used.

    - inside a try block. This will raise a RuntimeError that gets caught
      by the except clause.

      try:
          raise
      except Exception:
          pass


    - inside a finally clause. It might work or not, depending if there is
      an error raised inside the try block, but relying on this behaviour
      can be error prone.

      try:
          pass
      finally:
          raise

    - using a bare raise after an except clause caught the error in question.
      This works in Python 2, but the intent is nevertheless unclear. It won't
      work on Python 3, because the exception gets deleted after the exception
      clause, so it's best not to rely on this behaviour.

      exc = None
      try:
          1/0
      except ZeroDivisionError as exc:
          pass
      if exc:
          raise
