Used when there is no reference to the class, suggesting that the method could be used as a static function instead
If the class method does not reference any of the class attributes it may be more clear to define the method as a static function instead.

Attempt using either of the decorators @classmethod or @staticmethod

Ex:

    class Foo(object):
        ...
        def bar(self, baz):
            ...
            return llama


Try instead to use:

    class Foo(object):
        ...
        @classmethod
        def bar(cls, baz):
            ...
            return llama

[SOURCE](http://pylint-messages.wikidot.com/messages:R0201)