When a `lambda` is the first argument to `map` or `filter` it can be clearer as a list comprehension.

For example:

    my_list = [-3, -2, -1, 1, 2]
    value = 0

    r1 = [x for x in my_list if x > value]
    r2 = [x.value for x in some_list]

    r3 = filter(lambda x: x > value, my_list)
    r4 = map(lambda x: x.value, some_list)

[Source](http://stackoverflow.com/questions/3013449/list-filtering-list-comprehension-vs-lambda-filter)
      