Emitted when a with statement component returns multiple values and uses
name binding with `as` only for a part of those values, as in the following examples.
This can be misleading, since it's not clear if the context manager returns
a tuple or if the node without a name binding is another context manager.

    # Not clear if ctx() returns (value, other_ctx) or other_ctx is another
    # context manager altogether.    
    with ctx() as value, other_ctx:
         pass

This can be written more clearly as:


    with ctx() as value:
         with other_ctx:
             pass