package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_SprayUntrustedSessionCookie extends Pattern {
  
  private[this] lazy val sessionIdCookie = "JSESSIONID"

  override def apply(tree: Tree) = {
    if(hasSprayHint(tree)){
      tree.collect{
        case t@q"""cookie(${lit: Lit})""" if lit.value == sessionIdCookie =>
          Result(message,t)
        case t@q"""optionalCookie(${lit: Lit})""" if lit.value == sessionIdCookie =>
          Result(message,t)
      }
    }
    else Seq.empty
  }

  //this is merely to avoid false positives remove it if the pattern never encounters issues
  private[this] def hasSprayHint(tree:Tree):Boolean = {
    tree.collect{
      case importer"spray.http._" => true
    }.exists(identity)
  }

  private[this] def message = Message("Direct access to Session ID should be avoided")
}
