package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_UnencryptedSocket extends Pattern {

  override def apply(tree: Tree): List[Result] = {
    tree.collect {
      case t@init"$ctorname(..$params)" if ctorname.toString == "Socket" || ctorname.toString == "java.net.Socket" =>
        Result(message, t)
    }
  }

  private[this] def message = Message("Communication channel not encrypted")

}

