## If grouping expressions inside [[..]], use ( .. ).

### Problematic code:

```sh
[[ [ a || b ] && c ]]
[ [ a -o b ] -a c ]]
```

### Correct code:

```sh
[[ ( a || b ) && c ]]
[ \( a -o b \) -a c ]]  # or  { [ a ] || [ b ]; } && [ c ]
```
### Rationale:

`[ .. ]` should not be used to group subexpressions inside `[[ .. ]]` or `[ .. ]` statements.

For `[[ .. ]]`, use regular parentheses.

For `[ .. ]`, either use escaped parentheses, or preferably rewrite the expression into multiple `[ .. ]` joined with `&&`, `||` and `{ ..; }` groups. The latter is preferred because `[ .. ]` is undefined for more than 4 arguments in POSIX.

### Exceptions:

None

### Related resources:

* [Bash Pitfalls: `if [ [ a = b ] && [ c = d ] ]; then ...`](https://mywiki.wooledge.org/BashPitfalls#pf11)
* [POSIX `test`](http://pubs.opengroup.org/onlinepubs/9699919799/utilities/test.html)
[Source](https://github.com/koalaman/shellcheck/wiki/SC1026)

