## Couldn't find 'fi' for this 'if'.

### Problematic code:

```sh
if true
then
  echo "True"
done
```

### Correct code:

```sh
if true
then
  echo "True"
fi
```
### Rationale:

ShellCheck has found an `if` statement that does not appear to have a matching terminating `fi`.

This could be because it's missing entirely, or because the `if` statement was incorrectly terminated by a mismatched `done`, `esac`, `)` or similar. A companion warning [[SC1047]] is emitted at the point where ShellCheck expected the `fi`.

Check that the `if` statement is completely and correctly terminated.

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC1046)

