## Remove leading spaces before the shebang.

### Problematic code:

```sh
  #!/bin/sh
echo "Hello world"
```

### Correct code:

```sh
#!/bin/sh
echo "Hello World"
```
### Rationale:

The script has leading spaces before the shebang (`#!`). This is not allowed. 

The `#!` should be the first two bytes in the file, as they're used as a file signature by the OS to determine whether a file is a script.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1114)

