## Nothing allowed after end token. To continue a command, put it on the line with the `<<`.

### Problematic code:

```sh
cat << EOF
Hello
EOF | nl
```

### Correct code:

```sh
cat << EOF | nl
Hello
EOF
```
### Rationale:

You have a here document, and appear to have added text after the terminating token.

This is not allowed. If it was meant to continue the command, put it on the line with the `<<`.

If it helps, look at << "END" as if it was < file, and make sure the resulting command is valid. This is what the shell does. You can then append here document data after the command.

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC1122)

