# Useless cat. Consider 'cmd < file | ..' or 'cmd file | ..' instead.

### Problematic code:

```sh
cat file | tr ' ' _ | nl
cat file | while IFS= read -r i; do echo "${i%?}"; done
```

### Correct code:

```sh
< file tr ' ' _ | nl  
while IFS= read -r i; do echo "${i%?}"; done < file
```

### Rationale:

`cat` is a tool for con"cat"enating files. Reading a single file as input to a program is considered a [Useless Use Of Cat (UUOC)](http://en.wikipedia.org/wiki/Cat_(Unix)#Useless_use_of_cat).

It's more efficient and less roundabout to simply use redirection. This is especially true for programs that can benefit from seekable input, like `tail` or `tar`.

Many tools also accept optional filenames, e.g. `grep -q foo file` instead of `cat file | grep -q foo`.

### Exceptions

Pointing out UUOC is a long standing shell programming tradition, and removing them from a short-lived pipeline in a loop can speed it up by 2x. However, it's not necessarily a good use of time in practice, and rarely affects correctness. [[Ignore]] as you see fit.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2002)

