## SC2009 Consider using pgrep instead of grepping ps output.

### Problematic Code:

```sh
ps ax | grep -v grep | grep "$service" > /dev/null
```

### Correct Code:

```sh
pgrep -f "$service" > /dev/null
```

### Rationale:

If you are just after a pid from a running program, then pgrep is a much safer alternative. Especially if you are also looking for a pid belonging to a certain user or group. All of the parameters are in one command and it can eliminate multiple greps, cuts, seds, awks, ect.

### Exceptions

What if you have the pid and you are looking for the matching program name?

```sh
pid=123; ps ax | grep "$pid"
```

What if you want a range of the ps field, like from the 16th space to the end of the line?

```sh
ps ax | grep "$pid" | cut -d" " -f16-
```

Both are valid cases where SC2009 is not valid.


[Source](https://github.com/koalaman/shellcheck/wiki/SC2009)

