## Use '[:lower:]' to support accents and foreign alphabets.

### Problematic code:

```sh
PLATFORM="$(uname -s | tr 'A-Z' 'a-z')"
```

### Correct code:

```sh
PLATFORM="$(uname -s | tr '[:upper:]' '[:lower:]')"
```

### Rationale:

`A-Z` and `a-z` are commonly intended to mean "all uppercase" and "all lowercase letters" respectively. This ignores accented characters in English, and foreign characters in other languages:

    $ tr 'a-z' 'A-Z' <<< "My fiancée ordered a piña colada."
    MY FIANCéE ORDERED A PIñA COLADA.

Instead, you can use `[:lower:]` and `[:upper:]` to explicitly specify case:

    $ tr '[:lower:]' '[:upper:]' <<< "My fiancée ordered a piña colada."
    MY FIANCÉE ORDERED A PIÑA COLADA.

### Exceptions:

If you don't want `a-z` to match `é` or `A-Z` to match `Ñ`, you can ignore this message.

Note that the examples used here are multibyte characters in UTF-8. Many implementations (including GNU) fails to deal with them. 
[Source](https://github.com/koalaman/shellcheck/wiki/SC2018)

