##  To assign the output of a command, use var=$(cmd) .

### Problematic code:

```sh
var=grep -c pattern file
```

### Correct code:

```sh
var=$(grep -c pattern file)
```
### Rationale:

To assign the output of a command to a variable, use `$(command substitution)`. Just typing a command after the `=` sign does not work.

### Exceptions:

None. 

This warning triggers generally for `var=value -flag` and `var=value *glob*`. See related warning [[SC2209]] which matches `var=commonCommand`. 
[Source](https://github.com/koalaman/shellcheck/wiki/SC2037)

