## Unknown binary operator.

### Problematic code:

```sh
[ "$var" -leq 42 ]
```

### Correct code:

```sh
[ "$var" -le 42 ]
```

### Rationale:

You are using an unknown binary operator in a `test` expression. Choose one that exists.

In bash, use `help test` to see a list of supported operators:

      FILE1 -nt FILE2  True if file1 is newer than file2 (according to
                       modification date).

      FILE1 -ot FILE2  True if file1 is older than file2.

      FILE1 -ef FILE2  True if file1 is a hard link to file2.

      STRING1 = STRING2
                     True if the strings are equal.
      STRING1 != STRING2
                     True if the strings are not equal.
      STRING1 < STRING2
                     True if STRING1 sorts before STRING2 lexicographically.
      STRING1 > STRING2
                     True if STRING1 sorts after STRING2 lexicographically.

      arg1 OP arg2   Arithmetic tests.  OP is one of -eq, -ne,
                     -lt, -le, -gt, or -ge.

    Arithmetic binary operators return true if ARG1 is equal, not-equal,
    less-than, less-than-or-equal, greater-than, or greater-than-or-equal
    than ARG2.


### Exceptions:

None. If you've tested and verified that the operator works but the latest version of ShellCheck says it's unknown, please [submit a bug report](https://github.com/koalaman/shellcheck/issues).

### Related resources:

* [The classic test command](http://wiki.bash-hackers.org/commands/classictest) on the Bash Hackers wiki.
* [The conditional expression](http://wiki.bash-hackers.org/syntax/ccmd/conditional_expression) on the Bash Hackers wiki.
* [Tests and conditionals](https://mywiki.wooledge.org/BashGuide/TestsAndConditionals) on the Wooledge BashGuide.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2057)

