##  Tips depend on target shell and yours is unknown. Add a shebang.

### Problematic code:

```sh
echo "$RANDOM"   # Does this work?
```

### Correct code:

```sh
#!/bin/sh
echo "$RANDOM"  # Unsupported in sh. Produces warning.
```

or

```sh
#!/bin/bash
echo "$RANDOM"  # Supported in bash. No warnings.
```

### Rationale:

Different shells support different features. To give effective advice, ShellCheck needs to know which shell your script is going to run on. You will get a different numbers of warnings about different things depending on your target shell.

ShellCheck normally determines your target shell from the shebang (having e.g. `#!/bin/sh` as the first line). The shell can also be specified from the CLI with `-s`, e.g. `shellcheck -s sh file`.

If you don't specify shebang nor `-s`, ShellCheck gives this message and proceeds with some default (`bash`).

Note that this error can not be ignored with a [[directive]]. It is not a suggestion to improve your script, but a warning that ShellCheck lacks information it needs to be helpful.

### Exceptions

None. Please either add a shebang or use `-s`.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2148)

