## var is referenced but not assigned.

### Problematic code:

```sh
var=name
n=42
echo "$var_$n.jpg"   # overextended
```

or

```sh
target="world"
echo "hello $tagret"  # misspelled
```

or

```sh
echo "Result: ${mycmd -a myfile}"  # trying to execute commands
```

### Correct code:

```sh
var=name
n=42
echo "${var}_$n.jpg"
```

or

```sh
target="world"
echo "hello $target"
```

or

```sh
echo "Result: $(mycmd -a myfile)"
```

### Rationale:

ShellCheck has noticed that you reference a variable that is not assigned. Double check that the variable is indeed assigned, and that the name is not misspelled.

Note: This message only triggers for variables with lowercase characters in their name (`foo` and `kFOO` but not `FOO`) due to the standard convention of using lowercase variable names for unexported, local variables.

### Exceptions:

ShellCheck does not attempt to figure out runtime or dynamic assignments like with `source "$(date +%F).sh"` or `eval var=value`.

If you know for a fact that the variable is set, you can use `${var:?}` to fail if the variable is unset (or empty), or explicitly initialize/declare it with `var=""` or `declare var`. You can also disable the message with a [[directive]].

[Source](https://github.com/koalaman/shellcheck/wiki/SC2154)

