## read without -r will mangle backslashes

### Problematic code:

```sh
echo "Enter name:"
read name
```

### Correct code:

```sh
echo "Enter name:"
read -r name
```

### Rationale:

By default, `read` will interpret backslashes before spaces and line feeds, and otherwise strip them. This is rarely expected or desired.

Normally you just want to read data, which is what `read -r` does. You should always use `-r` unless you have a good reason not to.

Note that `read -r` will still strip leading and trailing spaces. `IFS="" read -r` prevents this.

### Exceptions:

If you want backslashes to affect field splitting and line terminators instead of being read, you can disable this message with a [[directive]].

[Source](https://github.com/koalaman/shellcheck/wiki/SC2162)

