Assignments within sub-expressions are hard to spot and therefore make the code less readable. Ideally, sub-expressions should not have
side-effects.

## Noncompliant Code Example

<pre>
if (string.IsNullOrEmpty(result = str.Substring(index, length))) // Noncompliant
{
  //...
}
</pre>

## Compliant Solution

<pre>
var result = str.Substring(index, length);
if (string.IsNullOrEmpty(result))
{
  //...
}
</pre>

## Exceptions

Assignments inside lambda and delegate expressions are allowed. 

Furthermore, the following patterns are also accepted:

<pre>
var a = b = c = 10;
</pre>

<pre>
while ((val = GetNewValue()) &gt; 0)
{
...
}
</pre>

<pre>
private MyClass instance;
public MyClass Instance
{
  get
  {
    return instance ?? (instance = new MyClass());
  }
}
</pre>

## See

*   MISRA C:2004, 13.1 - Assignment operators shall not be used in expressions that yield a Boolean value
*   MISRA C++:2008, 6-2-1 - Assignment operators shall not be used in sub-expressions
*   MISRA C:2012, 13.4 - The result of an assignment operator should not be used
*   [MITRE, CWE-481](http://cwe.mitre.org/data/definitions/481.html) - Assigning instead of Comparing
*   [CERT, EXP45-C.](https://www.securecoding.cert.org/confluence/x/nYFtAg) - Do not perform assignments in selection statements
*   [CERT, EXP51-J.](https://www.securecoding.cert.org/confluence/x/1gCTAw) - Do not perform assignments in conditional expressions

*   [CERT, EXP19-CPP.](https://www.securecoding.cert.org/confluence/x/KQvhAg) - Do not perform assignments in conditional expressions

*   [CERT, MSC02-CPP.](https://www.securecoding.cert.org/confluence/x/KYIyAQ) - Avoid errors of omission