Private, or `internal`, types or members that are never executed or referenced are dead code: unnecessary, inoperative code that should
be removed. Cleaning out dead code decreases the size of the maintained codebase, making it easier to understand the program and preventing bugs from
being introduced.

## Noncompliant Code Example

<pre>
public class Foo
{
  private void UnusedPrivateMethod() {...} // Noncompliant

  private class UnusedClass {...} // Noncompliant
}
</pre>

## Compliant Solution

<pre>
public class Foo
{
  private Foo()
  {
    UsedPrivateMethod();
  }

  private void UsedPrivateMethod()
  {
    var c = new UsedClass();
  }

  private class UsedClass {...}
}
</pre>

## Exceptions

This rule doesn't raise any issue on:

*   Empty constructors
*   Attributed members
*   Empty serialization constructor on type with `System.SerializableAttribute` attribute.
*   Internals in assemblies that have a `System.Runtime.CompilerServices.InternalsVisibleToAttribute` attribute.

## See

*   [CERT, MSC07-CPP.](https://www.securecoding.cert.org/confluence/x/OYIyAQ) - Detect and remove dead code