Using `.Count()` to test for emptiness works, but using `.Any()` makes the intent clearer, and the code more readable.
However, there are some cases where special attention should be paid:

- if the collection is an `EntityFramework` or other ORM query, calling `.Count()` will cause executing a potentially massive
SQL query and could put a large overhead on the application database. Calling `.Any()` will also connect to the database, but will generate
much more efficient SQL.

- if the collection is part of a LINQ query that contains `.Select()` statements that create objects, a large amount of memory could be
unnecessarily allocated. Calling `.Any()` will be much more efficient because it will execute fewer iterations of the enumerable.

## Noncompliant Code Example

<pre>
private static bool HasContent(IEnumerable
 <string>
   strings)
{
  return strings.Count() &gt; 0;  // Noncompliant
}

private static bool HasContent2(IEnumerable
  <string>
    strings) { return strings.Count() &gt;= 1; // Noncompliant } private static bool IsEmpty(IEnumerable
   <string>
     strings) { return strings.Count() == 0; // Noncompliant } 
   </string>
  </string>
 </string></pre>

## Compliant Solution

<pre>
private static bool HasContent(IEnumerable
 <string>
   strings)
{
  return strings.Any();
}

private static bool IsEmpty(IEnumerable
  <string>
    strings) { return !strings.Any(); } 
  </string>
 </string></pre>