`break;` is an unstructured control flow statement which makes code harder to read.

Ideally, every loop should have a single termination condition.

## Noncompliant Code Example

<pre>
int i = 0;
while (true)
{
  if (i == 10)
  {
    break;      // Non-Compliant
  }

  Console.WriteLine(i);
  i++;
}
</pre>

## Compliant Solution

<pre>
int i = 0;
while (i != 10) // Compliant
{
  Console.WriteLine(i);
  i++;
}
</pre>