The requirement for a final `default` clause is defensive programming. The clause should either take appropriate action, or contain a
suitable comment as to why no action is taken. Even when the `switch` covers all current values of an `enum`, a
`default` case should still be used because there is no guarantee that the `enum` won't be extended.

## Noncompliant Code Example

<pre>
int foo = 42;
switch (foo) // Noncompliant
{
  case 0:
    Console.WriteLine("foo = 0");
    break;
  case 42:
    Console.WriteLine("foo = 42");
    break;
}
</pre>

## Compliant Solution

<pre>
int foo = 42;
switch (foo) // Compliant
{
  case 0:
    Console.WriteLine("foo = 0");
    break;
  case 42:
    Console.WriteLine("foo = 42");
    break;
  default:
    throw new InvalidOperationException("Unexpected value foo = " + foo);
}
</pre>

## See

*   MISRA C:2004, 15.0 - The MISRA C _switch_ syntax shall be used.
*   MISRA C:2004, 15.3 - The final clause of a switch statement shall be the default clause
*   MISRA C++:2008, 6-4-3 - A switch statement shall be a well-formed switch statement.
*   MISRA C++:2008, 6-4-6 - The final clause of a switch statement shall be the default-clause
*   MISRA C:2012, 16.1 - All switch statements shall be well-formed
*   MISRA C:2012, 16.4 - Every _switch_ statement shall have a _default_ label
*   MISRA C:2012, 16.5 - A _default_ label shall appear as either the first or the last _switch label_ of a _switch_ statement

*   [MITRE, CWE-478](http://cwe.mitre.org/data/definitions/478.html) - Missing Default Case in Switch Statement
*   [CERT, MSC01-C.](https://www.securecoding.cert.org/confluence/x/YgE) - Strive for logical completeness
*   [CERT, MSC01-CPP.](https://www.securecoding.cert.org/confluence/x/JoIyAQ) - Strive for logical completeness