`StringBuilder` is more efficient than string concatenation, especially when the operator is repeated over and over as in loops.

## Noncompliant Code Example

<pre>
string str = "";
for (int i = 0; i &lt; arrayOfStrings.Length ; ++i)
{
  str = str + arrayOfStrings[i];
}
</pre>

## Compliant Solution

<pre>
StringBuilder bld = new StringBuilder();
for (int i = 0; i &lt; arrayOfStrings.Length; ++i)
{
  bld.Append(arrayOfStrings[i]);
}
string str = bld.ToString();
</pre>