There is no reason to re-assign a variable to itself. Either this statement is redundant and should be removed, or the re-assignment is a mistake
and some other value or variable was intended for the assignment instead.

## Noncompliant Code Example

<pre>
public void SetName(string name)
{
  name = name;
}
</pre>

## Compliant Solution

<pre>
public void SetName(string name)
{
  this.name = name;
}
</pre>

## See

*   [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never
      executed
*   [CERT, MSC12-CPP.](https://www.securecoding.cert.org/confluence/x/SIIyAQ) - Detect and remove code that has no effect