Having two `cases` in the same `switch` statement or branches in the same `if` structure with the same
implementation is at best duplicate code, and at worst a coding error. If the same logic is truly needed for both instances, then in an
`if` structure they should be combined, or for a `switch`, one should fall through to the other.

## Noncompliant Code Example

<pre>
switch (i)
{
  case 1:
    DoSomething();
    break;
  case 2:
    DoSomethingDifferent();
    break;
  case 3:  // Noncompliant; duplicates case 1's implementation
    DoSomething();
    break;
  default:
    DoTheRest();
}

if (a &gt;= 0 &amp;&amp; a &lt; 10)
{
  DoTheThing();
}
else if (a &gt;= 10 &amp;&amp; a &lt; 20)
{
  DoTheOtherThing();
}
else if (a &gt;= 20 &amp;&amp; a &lt; 50)
{
  DoTheThing();  // Noncompliant; duplicates first condition
}
else
{
  DoTheRest();
}

if (b == 0)
{
  DoOneMoreThing();
}
</pre>

## Compliant Solution

<pre>
switch (i) {
  case 1:
  case 3:
    DoSomething();
    break;
  case 2:
    DoSomethingDifferent();
    break;
  default:
    DoTheRest();
}

if ((a &gt;= 0 &amp;&amp; a &lt; 10) || (a &gt;= 20 &amp;&amp; a &lt; 50))
{
  DoTheThing();
}
else if (a &gt;= 10 &amp;&amp; a &lt; 20)
{
  DoTheOtherThing();
}
else
{
  DoTheRest();
}

DoOneMoreThing();
</pre>

or

<pre>
switch (i)
{
  case 1:
    DoSomething();
    break;
  case 2:
    DoSomethingDifferent();
    break;
  case 3:
    DoThirdThing();
    break;
  default:
    DoTheRest();
}

if (a &gt;= 0 &amp;&amp; a &lt; 10)
{
  DoTheThing();
}
else if (a &gt;= 10 &amp;&amp; a &lt; 20)
{
  DoTheOtherThing();
}
else if (a &gt;= 20 &amp;&amp; a &lt; 50)
{
  DoTheThirdThing();
}
else
{
  DoTheRest();
}
</pre>

## Exceptions

Blocks in an `if` chain that contain a single line of code are ignored, as are blocks in a `switch` statement that contain a
single line of code with or without a following `break`.