A reference to `null` should never be dereferenced/accessed. Doing so will cause a `NullReferenceException` to be thrown. At
best, such an exception will cause abrupt program termination. At worst, it could expose debugging information that would be useful to an attacker, or
it could allow an attacker to bypass security measures.

## Noncompliant Code Example

<pre>
object o = null;
if (condition)
{
  M1(o.ToString()); // Noncompliant, always null
}
else
{
  o = new object();
}
M2(o.ToString());
</pre>

## Exceptions

Calls to extension methods are not reported as those can still operate on a `null` value.

## See

*   [MITRE, CWE-476](http://cwe.mitre.org/data/definitions/476.html) - NULL Pointer Dereference
*   [CERT, EXP34-C.](https://www.securecoding.cert.org/confluence/x/PAw) - Do not dereference null pointers
*   [CERT, EXP01-J.](https://www.securecoding.cert.org/confluence/x/ZwDOAQ) - Do not use a null in a case where an object is required