`Enumerable.Sum()` always executes addition in a `checked` context, so an `OverflowException` will be thrown if
the value exceeds `MaxValue` even if an `unchecked` context was specified. Using an `unchecked` context anyway
represents a misunderstanding of how `Sum` works.

This rule raises an issue when an `unchecked` context is specified for a `Sum` on integer types.

## Noncompliant Code Example

<pre>
void Add(List
 <int>
   list)
{
  int d = unchecked(list.Sum());  // Noncompliant

  unchecked
  {
    int e = list.Sum();  // Noncompliant
  }
}

 </int></pre>

## Compliant Solution

<pre>
void Add(List
 <int>
   list)
{
  int d = list.Sum();

  try
  {
    int e = list.Sum();
  }
  catch (System.OverflowException e)
  {
    // exception handling...
  }
}

 </int></pre>

## Exceptions

When the `Sum()` call is inside a `try-catch` block, no issues are reported.

<pre>
void Add(List
 <int>
   list)
{
  unchecked
  {
    try
    {
      int e = list.Sum();
    }
    catch (System.OverflowException e)
    {
      // exception handling...
    }
  }
}

 </int></pre>