Having a variable with the same name in two unrelated classes is fine, but do the same thing within a class hierarchy and you'll get confusion at
best, chaos at worst. Perhaps even worse is the case where a child class field varies from the name of a parent class only by case.

## Noncompliant Code Example

<pre>
public class Fruit
{
  protected Season ripe;
  protected Color flesh;

  // ...
}

public class Raspberry : Fruit
{
  private bool ripe; // Noncompliant
  private static Color FLESH; // Noncompliant
}
</pre>

## Compliant Solution

<pre>
public class Fruit
{
  protected Season ripe;
  protected Color flesh;

  // ...
}

public class Raspberry : Fruit
{
  private bool ripened;
  private static Color FLESH_COLOR;
}
</pre>

## Exceptions

This rule ignores `private` parent class fields, but in all other such cases, the child class field should be renamed.

<pre>
public class Fruit
{
  private Season ripe;
  // ...
}

public class Raspberry : Fruit
{
  private Season ripe;  // Compliant as parent field 'ripe' is anyway not visible from Raspberry
  // ...
}
</pre>