When exceptions occur, it is usually a bad idea to simply ignore them. Instead, it is better to handle them properly, or at least to log them.

This rule only reports on empty catch clauses that catch generic `Exception`s.

## Noncompliant Code Example

<pre>
string text = "";
try
{
  text = File.ReadAllText(fileName);
}
catch (Exception exc) // Noncompliant
{
}
</pre>

## Compliant Solution

<pre>
string text = "";
try
{
  text = File.ReadAllText(fileName);
}
catch (Exception exc)
{
  logger.Log(exc);
}
</pre>

## Exceptions

When a block contains a comment, it is not considered to be empty.

## See

*   [MITRE, CWE-391](http://cwe.mitre.org/data/definitions/391.html) - Unchecked Error Condition